/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.dialog.comp.DateParameterJPanel;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Months;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.YearClockParameter;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class YearClockPanel
extends AbstractProtectionPanel {
    private static final long serialVersionUID = 1L;
    private DateParameterJPanel ivjOffTime = null;
    private DateParameterJPanel ivjOnTime = null;
    private JCheckBox fEveryMonth;
    private EditableNumericSpinner fOnYear;
    private EditableNumericSpinner fOffYear;
    private BorderJPanel fOnYearPane;
    private BorderJPanel fOffYearPane;
    protected JCheckBox cbPulse;
    protected JCheckBox cbYearly;

    public YearClockPanel() {
        this.initialize();
    }

    public YearClockPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        YearClockParameter param = (YearClockParameter)parameterReference;
        JPanel panel = new JPanel(new GridLayout(0, 2));
        this.addParameterPane(panel);
        this.getOnTime().setParameterReference(param.getOnTime());
        panel.add(this.getOnTime());
        this.getOffTime().setParameterReference(param.getOffTime());
        panel.add(this.getOffTime());
        panel.add(this.getOnYearPane());
        panel.add(this.getOffYearPane());
        this.getEveryMonth().addItemListener(new SettingsListener());
        panel.add(this.getEveryMonth());
        Hardware hw = param.getBlock().getWiringDiagram().getHardware();
        this.fOnYearPane.setVisible(hw.supports("yearRangePulseYearClock"));
        this.fOffYearPane.setVisible(hw.supports("yearRangePulseYearClock"));
        this.cbYearly = new JCheckBox();
        panel.add(this.cbYearly);
        this.cbYearly.setVisible(hw.supports("yearRangePulseYearClock"));
        this.cbYearly.addItemListener(new SettingsListener());
        this.cbPulse = new JCheckBox();
        this.cbPulse.addItemListener(new SettingsListener());
        this.globalParamPane.add(this.cbPulse);
        this.cbPulse.setVisible(hw.supports("yearRangePulseYearClock"));
        if (!hw.supports("yearClockEveryDay")) {
            this.getEveryMonth().setVisible(false);
        }
    }

    public boolean checkChanged() {
        YearClockParameter parameter = (YearClockParameter)this.fParameterReference;
        if (this.getOnTime().checkChanged()) {
            return true;
        }
        if (this.getOffTime().checkChanged()) {
            return true;
        }
        if (this.getEveryMonth().isSelected() != parameter.isEveryMonth()) {
            return true;
        }
        if (this.fOnYear.checkChanged() || this.fOffYear.checkChanged()) {
            return true;
        }
        if (this.cbPulse.isSelected() != parameter.getPulse().booleanValue()) {
            return true;
        }
        if (this.cbYearly.isSelected() != parameter.isYearly().booleanValue()) {
            return true;
        }
        return super.checkChanged();
    }

    public boolean checkFieldContents() {
        if (!this.getOnTime().checkFieldContents()) {
            return false;
        }
        if (!this.getOffTime().checkFieldContents()) {
            return false;
        }
        if (!this.fOnYear.checkValue(true)) {
            return false;
        }
        if (!this.fOffYear.checkValue(true)) {
            return false;
        }
        if (!this.fOffYear.isEnabled()) {
            if (!this.cbPulse.isEnabled() || this.cbYearly.isSelected()) {
                System.err.println("Error in YearClockPanel.");
            }
        } else if (this.cbPulse.isSelected()) {
            if (this.fOnYear.getValue() > this.fOffYear.getValue()) {
                new LogoError(null, "error.dialog.invalidYear", "Off-Year should not earlier than On-Year").display();
                return false;
            }
        } else {
            boolean validSet = false;
            if (this.fOffYear.getValue() > this.fOnYear.getValue()) {
                validSet = true;
            } else if (this.fOffYear.getValue() == this.fOnYear.getValue()) {
                Months onTime = new Months();
                onTime.setTime(this.ivjOnTime.getMonth(), this.ivjOnTime.getDay());
                Months offTime = new Months();
                offTime.setTime(this.ivjOffTime.getMonth(), this.ivjOffTime.getDay());
                if (this.fEveryMonth.isSelected()) {
                    validSet = true;
                } else if (offTime.compare(onTime) >= 0) {
                    validSet = true;
                }
            }
            if (!validSet) {
                new LogoError(null, "error.dialog.invalidDate", "Off-Date should not earlier than On-Date").display();
                return false;
            }
        }
        return super.checkFieldContents();
    }

    private DateParameterJPanel getOffTime() {
        if (this.ivjOffTime == null) {
            try {
                this.ivjOffTime = new DateParameterJPanel();
                this.ivjOffTime.setName("OffTime");
                this.ivjOffTime.setPreferredSize(new Dimension(300, 60));
                this.ivjOffTime.setTitle(Language.getString("dialog.parameter.cam.offTime", "Off Time"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOffTime;
    }

    private DateParameterJPanel getOnTime() {
        if (this.ivjOnTime == null) {
            try {
                this.ivjOnTime = new DateParameterJPanel();
                this.ivjOnTime.setName("OnTime");
                this.ivjOnTime.setTitle(Language.getString("dialog.parameter.cam.onTime", "On Time"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOnTime;
    }

    private BorderJPanel getOnYearPane() {
        if (this.fOnYearPane == null) {
            this.fOnYearPane = new BorderJPanel();
            this.fOnYearPane.setLayout(new GridBagLayout());
        }
        if (this.fOnYear == null) {
            this.fOnYear = new EditableNumericSpinner();
            this.fOnYear.setLayout(null);
            this.fOnYear.setBounds(0, 0, 64, 24);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.anchor = 18;
            this.fOnYearPane.add((Component)this.getLabelDate(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.anchor = 18;
            this.fOnYearPane.add((Component)this.fOnYear, gbc);
        }
        return this.fOnYearPane;
    }

    private BorderJPanel getOffYearPane() {
        if (this.fOffYearPane == null) {
            this.fOffYearPane = new BorderJPanel();
            this.fOffYearPane.setLayout(new GridBagLayout());
        }
        if (this.fOffYear == null) {
            this.fOffYear = new EditableNumericSpinner();
            this.fOffYear.setLayout(null);
            this.fOffYear.setBounds(0, 0, 64, 24);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.anchor = 18;
            this.fOffYearPane.add((Component)this.getLabelDate(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.anchor = 18;
            this.fOffYearPane.add((Component)this.fOffYear, gbc);
        }
        return this.fOffYearPane;
    }

    private JLabel getLabelDate() {
        JLabel ret = new JLabel();
        ret.setName("LabelDate");
        ret.setText(Language.getString("dialog.parameter.yearClock.yearTag", "Year?"));
        ret.setBounds(9, 16, 100, 24);
        ret.setForeground(Color.black);
        return ret;
    }

    private JCheckBox getEveryMonth() {
        if (this.fEveryMonth == null) {
            this.fEveryMonth = new JCheckBox();
            this.fEveryMonth.setName("everyMonth");
        }
        return this.fEveryMonth;
    }

    private void settingsChanged() {
        boolean monthly = this.getEveryMonth().isSelected();
        boolean pulse = this.cbPulse.isSelected();
        this.cbYearly.setEnabled(!monthly);
        if (monthly) {
            this.cbYearly.setSelected(true);
        }
        this.getOnTime().setMonthEnabled(!monthly);
        this.getOffTime().setMonthEnabled(!monthly && !pulse);
        this.getOffTime().setDayEnabled(!pulse);
        boolean offYeardisabled = !this.cbYearly.isSelected() && this.cbPulse.isSelected();
        this.fOffYear.setEnabled(!offYeardisabled);
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() {
        this.setName("YearClockPanel");
        this.setSize(324, 242);
        this.add((Component)this.getOnTime(), this.getOnTime().getName());
        this.add(this.getOffTime());
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        YearClockParameter parameter = (YearClockParameter)this.fParameterReference;
        this.getOnTime().loadFieldContents();
        this.getOffTime().loadFieldContents();
        this.getEveryMonth().setSelected(parameter.isEveryMonth());
        this.fOffYear.setProperties(parameter.getOffYear());
        this.fOnYear.setProperties(parameter.getOnYear());
        this.cbPulse.setSelected(parameter.getPulse());
        this.cbYearly.setSelected(parameter.isYearly());
        this.settingsChanged();
    }

    public void setLabels() {
        super.setLabels();
        this.getOnTime().setTitle(Language.getString("dialog.parameter.cam.onTime", "Switch on time"));
        this.getOffTime().setTitle(Language.getString("dialog.parameter.cam.offTime", "Switch off time"));
        this.getEveryMonth().setText(Language.getString("dialog.parameter.cam.everyMonth", "Every month"));
        this.getOnYearPane().setTitle(Language.getString("dialog.parameter.cam.onYear", "On year?"));
        this.getOnYearPane().setTitleColor(Color.black);
        this.getOffYearPane().setTitle(Language.getString("dialog.parameter.cam.offYear", "Off year?"));
        this.getOffYearPane().setTitleColor(Color.black);
        this.cbYearly.setText(Language.getString("dialog.parameter.cam.yearly", "Every year"));
        this.cbPulse.setText(Language.getString("dialog.parameter.output.pulse", "Pulse Output"));
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        YearClockParameter parameter = (YearClockParameter)this.fParameterReference;
        this.getOnTime().storeFieldContents();
        this.getOffTime().storeFieldContents();
        parameter.setEveryMonth(this.getEveryMonth().isSelected());
        parameter.setPulse(this.cbPulse.isSelected());
        parameter.setYearly(this.cbYearly.isSelected());
        parameter.setOnYear(this.fOnYear.getValue());
        parameter.setOffYear(this.fOffYear.getValue());
    }

    class SettingsListener
    implements ItemListener {
        SettingsListener() {
        }

        public void itemStateChanged(ItemEvent event) {
            YearClockPanel.this.settingsChanged();
        }
    }
}

